/*
 * Decompiled with CFR 0.152.
 */
package org.trapdoor.decorum;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.Path;
import org.trapdoor.decorum.Build;
import org.trapdoor.decorum.Copy;
import org.trapdoor.decorum.Dependency;
import org.trapdoor.decorum.Version;
import org.trapdoor.decorum.VersionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decorum
extends Task {
    private static Comparator versionComparator = new VersionComparator();
    private String id;
    private String excludes;
    private String excludesChecks;
    private Path searchPath;
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private Path outPath;
    private boolean done;
    private boolean skipBuild;

    public void init() {
        Project project = this.getProject();
        this.searchPath = new Path(project);
        this.outPath = new Path(project);
        for (Object e : project.getBuildListeners()) {
            if (!e.getClass().getName().equals("org.trapdoor.decorum.Decorum$DepBuildListener")) continue;
            try {
                Method method = e.getClass().getMethod("getPath", new Class[0]);
                File file = (File)method.invoke(e, new Object[0]);
                method = e.getClass().getMethod("getId", new Class[0]);
                String string = (String)method.invoke(e, new Object[0]);
                if (!file.equals(project.getBaseDir()) || string.equals(string)) continue;
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        project.addBuildListener((BuildListener)new DepBuildListener());
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setLibdir(Path path) {
        this.searchPath.append(path);
    }

    public void setExcludes(String string) {
        this.excludes = string;
    }

    public void setExcludeschecks(String string) {
        this.excludesChecks = string;
    }

    public void addLibdir(Path path) {
        this.searchPath.append(path);
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    private List<String> processDependency(Dependency dependency) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Dependency object32 : dependency.getDependencies()) {
            arrayList.addAll(this.processDependency(object32));
        }
        VersionFilter versionFilter = new VersionFilter(dependency.getName(), dependency.getVersion(), dependency.getAllowNonVersion());
        for (String string : this.searchPath.list()) {
            object2 = new File(string);
            object = ((File)object2).listFiles(versionFilter);
            if (object == null || ((File[])object).length == 0) continue;
            File file = object[((File[])object).length - 1];
            Path path = new Path(this.getProject());
            path.setPath(file.getPath());
            this.outPath.add(path);
            return arrayList;
        }
        Build build = dependency.getBuild();
        if (build != null) {
            Object object3;
            File file;
            String string;
            String string2 = build.getBase();
            string = this.getProject().getProperty("decorum." + dependency.getName() + ".basedir");
            object2 = this.getProject().getProperty("decorum.basedir");
            if (object2 == null) {
                object2 = "..";
            }
            if (!(file = string != null ? new File(string) : (string2 != null ? new File(string2) : new File(new File((String)object2), dependency.getName()))).isDirectory()) {
                if (dependency.isRequired()) {
                    arrayList.add("Dependency " + dependency.getName() + " failed: Base " + file.getPath() + " does not exist or is not a readable directory");
                }
                return arrayList;
            }
            object = new File(file, "build.xml");
            if (!((File)object).exists()) {
                if (dependency.isRequired()) {
                    arrayList.add("Dependency " + dependency.getName() + " failed: Build file " + ((File)object).getPath() + " does not exist");
                }
                return arrayList;
            }
            long l = -1L;
            long l2 = -1L;
            if (this.skipBuild) {
                System.out.println("*** Skipping checks for " + dependency.getName() + " ***");
            } else {
                Property property;
                object3 = (Ant)this.getProject().createTask("ant");
                for (Copy copy : build.getCopies()) {
                    property = object3.createProperty();
                    property.setName(copy.getProperty());
                    property.setValue(this.getProject().getProperty(copy.getProperty()));
                }
                for (Property property2 : build.getParams()) {
                    property = object3.createProperty();
                    property.setName(property2.getName());
                    property.setValue(property2.getValue());
                }
                object3.setInheritAll(false);
                object3.setDir(file);
                object3.setAntfile(((File)object).getPath());
                object3.setTarget("jar");
                l = this.getJarModificationTime(build.getDistdir(), file, dependency.getName());
                if (l >= 0L) {
                    l2 = this.getMaxModificationTime(file, l);
                }
                if (l2 < 0L || l < 0L || l2 > l) {
                    System.out.println("+++ [" + dependency.getName() + "] +++");
                    System.out.println("*** Building " + dependency.getName() + " using " + ((File)object).getPath() + " ***");
                    object3.execute();
                } else {
                    System.out.println("*** " + dependency.getName() + " is up-to-date ***");
                }
            }
            object3 = build.getDistdir();
            File file2 = new File(file, object3 == null ? "dist" : object3);
            ProjectFilter projectFilter = new ProjectFilter(dependency.getName());
            if (!file2.isDirectory()) {
                if (dependency.isRequired()) {
                    arrayList.add("Dependency " + dependency.getName() + " failed: Distribution dir " + file2.getPath() + " does not exist or is not a readable directory");
                }
                return arrayList;
            }
            boolean bl = false;
            for (File file3 : file2.listFiles(projectFilter)) {
                File file4;
                bl = true;
                if (build.getDest() != null) {
                    file4 = new File(build.getDest());
                    if (!file4.isDirectory()) {
                        if (dependency.isRequired()) {
                            arrayList.add("Dependency " + dependency.getName() + " failed: Destination " + file4.getPath() + " does not exist or is not a readable directory");
                        }
                        return arrayList;
                    }
                    org.apache.tools.ant.taskdefs.Copy copy = (org.apache.tools.ant.taskdefs.Copy)this.getProject().createTask("copy");
                    copy.setFile(file3);
                    copy.setTodir(file4);
                    copy.execute();
                    Path path = new Path(this.getProject());
                    path.setPath(new File(file4, file3.getName()).getPath());
                    this.outPath.add(path);
                    continue;
                }
                file4 = new Path(this.getProject());
                file4.setPath(file3.getPath());
                this.outPath.add((Path)file4);
            }
            if (!(this.skipBuild || l2 >= 0L && l >= 0L && l2 <= l)) {
                System.out.println("--- [" + dependency.getName() + "] ---");
            }
            if (bl) {
                return arrayList;
            }
        }
        if (dependency.isRequired()) {
            arrayList.add("Dependency " + dependency.getName() + " " + (dependency.getVersion() == null ? "" : dependency.getVersionString()) + " not met.");
        }
        return arrayList;
    }

    private long getJarModificationTime(String string, File file, String string2) {
        File file2 = new File(file, string == null ? "dist" : string);
        ProjectFilter projectFilter = new ProjectFilter(string2);
        if (!file2.isDirectory()) {
            return -1L;
        }
        int n = 0;
        File[] fileArray = file2.listFiles(projectFilter);
        int n2 = fileArray.length;
        if (n < n2) {
            File file3 = fileArray[n];
            return file3.lastModified();
        }
        return -1L;
    }

    private long getMaxModificationTime(File file, long l) {
        File file2;
        LinkedList<File> linkedList = new LinkedList<File>();
        linkedList.add(file);
        long l2 = -1L;
        while (null != (file2 = (File)linkedList.poll())) {
            long l3 = file2.lastModified();
            if (l3 > l) {
                return l3;
            }
            if (l3 > l2) {
                l2 = l3;
            }
            if (!file2.isDirectory()) continue;
            linkedList.addAll(Arrays.asList(file2.listFiles()));
        }
        return l2;
    }

    public List<String> processDependencies() throws BuildException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Dependency dependency : this.dependencies) {
            arrayList.addAll(this.processDependency(dependency));
        }
        this.getProject().addReference("path." + this.id, (Object)this.outPath);
        return arrayList;
    }

    protected static class VersionFilter
    implements FileFilter {
        private String name;
        private Version version;
        private boolean allowNonVersion;
        private String maxFoundVersion;

        public VersionFilter(String string, Version version, boolean bl) {
            this.name = string;
            this.version = version;
            this.allowNonVersion = bl;
        }

        public boolean accept(File file) {
            String string = this.doAccept(file);
            if (string == null) {
                return false;
            }
            if (this.maxFoundVersion == null || versionComparator.compare(string, this.maxFoundVersion) > 0) {
                this.maxFoundVersion = string;
                return true;
            }
            return false;
        }

        public String doAccept(File file) {
            if (file.isDirectory()) {
                return null;
            }
            String string = file.getName();
            if (string == null) {
                return null;
            }
            if (string.equals(this.name + ".jar")) {
                return this.allowNonVersion ? "" : null;
            }
            if (!string.startsWith(this.name + "-")) {
                return null;
            }
            if (!Character.isDigit(string.charAt(this.name.length() + 1))) {
                return null;
            }
            if (!string.endsWith(".jar")) {
                return null;
            }
            String string2 = string.substring(this.name.length() + 1, string.length() - 4);
            string = string.substring(0, this.name.length());
            if (this.version == null) {
                return string2;
            }
            if (this.version.getLowestVersion() == null) {
                return versionComparator.compare(string2, this.version.getHighestVersion()) <= 0 ? string2 : null;
            }
            if (this.version.getHighestVersion() == null) {
                return versionComparator.compare(string2, this.version.getLowestVersion()) >= 0 ? string2 : null;
            }
            return versionComparator.compare(string2, this.version.getLowestVersion()) == 0 ? string2 : null;
        }
    }

    protected static class ProjectFilter
    implements FileFilter {
        private String name;

        public ProjectFilter(String string) {
            this.name = string;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            String string = file.getName();
            if (string == null) {
                return false;
            }
            return string.startsWith(this.name) && string.endsWith(".jar");
        }
    }

    public class DepBuildListener
    implements BuildListener {
        public File getPath() {
            return Decorum.this.getProject().getBaseDir();
        }

        public String getId() {
            return Decorum.this.id;
        }

        public void buildStarted(BuildEvent buildEvent) {
        }

        public void buildFinished(BuildEvent buildEvent) {
        }

        public void targetStarted(BuildEvent buildEvent) {
            String string = buildEvent.getTarget().getName();
            if (Decorum.this.excludes != null) {
                for (String object : Decorum.this.excludes.split(",")) {
                    if (!string.equals(object)) continue;
                    return;
                }
            }
            if (Decorum.this.excludesChecks != null) {
                for (String string2 : Decorum.this.excludesChecks.split(",")) {
                    if (!string.equals(string2)) continue;
                    Decorum.this.skipBuild = true;
                }
            }
            if (!Decorum.this.done) {
                Decorum.this.done = true;
                List<String> list = Decorum.this.processDependencies();
                if (!list.isEmpty()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        stringBuffer.append(string3);
                        stringBuffer.append("\n");
                    }
                    throw new BuildException("Dependencies Not Met:\n" + stringBuffer);
                }
            }
        }

        public void targetFinished(BuildEvent buildEvent) {
        }

        public void taskStarted(BuildEvent buildEvent) {
        }

        public void taskFinished(BuildEvent buildEvent) {
        }

        public void messageLogged(BuildEvent buildEvent) {
        }
    }
}

