/*
 * Java properties library
 * Copyright (C) 2003 Jon Siddle <jon@trapdoor.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.trapdoor.properties;

public abstract class CompiledProperty extends ClassProperty {
	protected CompiledProperty(ClassPropertyKey key,int access,Class propertyType,boolean staticProperty) {
		super(key.getDeclaringClass(),key.getPropertyName(),access,propertyType,staticProperty,key.isDynamicNullHandling());
	}

	protected static void registerObject(Object key, Object value) {
		DynamicClassManager.registerObject(key,value);
	}

	public String shortClassName(Class clazz) {
		String className=clazz.getName();
		int pkgIndex = className.lastIndexOf(".");
		if(pkgIndex>=0)className=className.substring(pkgIndex+1);
		return className;
	}

	public String toString() {
		return "["+shortClassName(getClass())+","
			   +shortClassName(getDeclaringClass())+"|"+getPropertyName()+","
			   +"DN:"+isDynamicNullHandling()+","
			   +"AM:"+getAccessMode()+","
			   +shortClassName(getPropertyType())+","
			   +"SP:"+isStatic()+"]";
	}
}
