/*
 * Java properties library
 * Copyright (C) 2003 Jon Siddle <jon@trapdoor.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package test;

import junit.framework.TestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.trapdoor.properties.*;

public class SimplePropertyTest extends TestCase {
	public static class TestClass {
		private Integer a;
		public void setA(Integer a) { this.a = a; }
		public Integer getA() { return a; }

		private static int b;
		public static void setB(int b) { TestClass.b = b; }
		public static int getB() { return b; }
	}

	/* Test the basic properties of a ClassProperty */
        public void testPropertyCreation() {
		ClassProperty p = SimpleClassProperty.createProperty(TestClass.class,"A",false);
		assertEquals("A", p.getPropertyName());
		assertEquals(TestClass.class, p.getDeclaringClass());
		assertEquals(Integer.class, p.getPropertyType());
		assertFalse(p.isStatic());

		p = SimpleClassProperty.createProperty(TestClass.class,"B",false);
		assertEquals("B", p.getPropertyName());
		assertEquals(TestClass.class, p.getDeclaringClass());
		assertEquals(int.class, p.getPropertyType());
		assertTrue(p.isStatic());

		try {
		  p = SimpleClassProperty.createProperty(TestClass.class,"C",false);
		  fail("Exception not thrown for non-existant property");
		} catch(Exception e) {
		}
	}

	/* Test basic value manipulation */
        public void testPropertyValueManipulation() {
		TestClass t = new TestClass();

		ClassProperty p = SimpleClassProperty.createProperty(TestClass.class,"A",false);
		assertEquals(t,p.getTarget(t));
		p.setValue(t,new Integer(5));
		Object val = p.getValue(t);
		assertTrue(val instanceof Integer);
		assertEquals(new Integer(5),val);

		p = SimpleClassProperty.createProperty(TestClass.class,"B",false);
		assertEquals(t,p.getTarget(t));
		p.setValue(t,new Integer(3));
		val = p.getValue(t);
		assertTrue(val instanceof Integer);
		assertEquals(new Integer(3),val);
        }

	public void testDynamicNull() {
		ClassProperty p = SimpleClassProperty.createProperty(TestClass.class,"A",true);
		assertNull(p.getTarget(null));
		assertNull(p.getValue(null));
		try {
		  p.setValue(null,new Integer(5));
		  fail("Exception not thrown for write to null property target");
		} catch(Exception e) {
		}
	}

        public static Test suite() {
                return new TestSuite(SimplePropertyTest.class);
        }
}

