/*
 * Decompiled with CFR 0.152.
 */
package org.trapdoor.properties;

import org.trapdoor.properties.ClassProperty;

public class ClassPropertyKey {
    private Class declaringClass;
    private String propertyName;
    private boolean isDynamicNullHandling;

    public ClassPropertyKey(Class clazz, String string, boolean bl) {
        this.declaringClass = clazz;
        this.propertyName = string;
        this.isDynamicNullHandling = bl;
    }

    public ClassPropertyKey(ClassProperty classProperty) {
        this(classProperty.getDeclaringClass(), classProperty.getPropertyName(), classProperty.isDynamicNullHandling());
    }

    public int hashCode() {
        return 31 * (this.isDynamicNullHandling ? 1231 : 1237) * this.declaringClass.hashCode() * 13 + this.propertyName.hashCode();
    }

    public boolean equals(Object object) {
        ClassPropertyKey classPropertyKey = (ClassPropertyKey)object;
        return classPropertyKey.declaringClass == this.declaringClass && (classPropertyKey.propertyName == null && this.propertyName == null || classPropertyKey.propertyName.equals(this.propertyName)) && classPropertyKey.isDynamicNullHandling == this.isDynamicNullHandling;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isDynamicNullHandling() {
        return this.isDynamicNullHandling;
    }

    public String toString() {
        String string = this.getDeclaringClass().getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return "[" + string + "|" + this.getPropertyName() + "|" + this.isDynamicNullHandling() + "]";
    }
}

