/*
 * Decompiled with CFR 0.152.
 */
package org.trapdoor.properties;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class DynamicClassManager {
    private static Logger logger = Logger.getLogger((Class)DynamicClassManager.class);
    private static File path;
    private static ClassLoader classLoader;
    private static HashMap objectMap;

    public static void init(File file) {
        path = file;
    }

    public static boolean containsKey(Object object) {
        return objectMap.containsKey(object);
    }

    public static Object getObject(Object object) throws IOException {
        return objectMap.get(object);
    }

    public static void loadClass(String string) throws ClassNotFoundException {
        Object object;
        try {
            if (classLoader == null) {
                object = "file:" + path.getPath() + "/";
                classLoader = new URLClassLoader(new URL[]{new URL((String)object)}, DynamicClassManager.class.getClassLoader());
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
        try {
            object = Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error((Object)("Error Loading class: " + string + " from " + path.getPath()));
            throw classNotFoundException;
        }
    }

    public static File fileForClass(String string) {
        string = string.replace('.', File.separatorChar);
        File file = new File(path, string + ".class");
        file.getParentFile().mkdirs();
        return file;
    }

    public static void purge() {
        DynamicClassManager.discardClassLoader();
        objectMap.clear();
    }

    public static void load() throws ClassNotFoundException {
        DynamicClassManager.load(path);
    }

    private static void load(File file) throws ClassNotFoundException {
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                DynamicClassManager.load(fileArray[i]);
                continue;
            }
            String string = fileArray[i].getAbsolutePath();
            String string2 = path.getAbsolutePath();
            int n = string.indexOf(".class");
            if (n < 0) {
                logger.warn((Object)(string + " is not a .class file."));
                continue;
            }
            try {
                DynamicClassManager.loadClass(string.substring(string2.length() + 1, n).replace(File.separatorChar, '.'));
                continue;
            }
            catch (Throwable throwable) {
                logger.debug((Object)throwable);
                logger.warn((Object)(string + " could not be loaded, deleting to allow regeneration."));
                if (fileArray[i].delete()) continue;
                logger.error((Object)(string + " could not be loaded, and could not be deleted."));
            }
        }
    }

    public static int nextId(String string) {
        int n = 1;
        while (DynamicClassManager.fileForClass(string + n).exists()) {
            ++n;
        }
        return n;
    }

    public static void discardClassLoader() {
        classLoader = null;
    }

    public static void registerObject(Object object, Object object2) {
        logger.debug((Object)("Registering " + object2));
        objectMap.put(object, object2);
    }

    public static File getPath() {
        return path;
    }

    static {
        objectMap = new HashMap();
    }
}

