/*
 * Decompiled with CFR 0.152.
 */
package org.trapdoor.properties;

import cojen.classfile.CodeBuilder;
import cojen.classfile.Label;
import cojen.classfile.LocalVariable;
import cojen.classfile.Location;
import cojen.classfile.TypeDesc;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.trapdoor.properties.ClassProperty;
import org.trapdoor.properties.ClassPropertyKey;
import org.trapdoor.properties.SimpleClassProperty;

public class NestedClassProperty
extends ClassProperty {
    List propertyList = new ArrayList();

    public NestedClassProperty(Class clazz, String string, List list, boolean bl) throws IllegalArgumentException {
        super(clazz, string, NestedClassProperty.plAccess(list), NestedClassProperty.plType(list), NestedClassProperty.plStatic(list), bl);
        this.propertyList = list;
    }

    private static ClassProperty lastProperty(List list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("null or zero length property list");
        }
        return (ClassProperty)list.get(list.size() - 1);
    }

    private static int plAccess(List list) {
        return NestedClassProperty.lastProperty(list).getAccessMode();
    }

    private static Class plType(List list) {
        return NestedClassProperty.lastProperty(list).getPropertyType();
    }

    private static boolean plStatic(List list) {
        return NestedClassProperty.lastProperty(list).isStatic();
    }

    public static ClassProperty createProperty(ClassPropertyKey classPropertyKey) {
        return NestedClassProperty.createProperty(classPropertyKey.getDeclaringClass(), classPropertyKey.getPropertyName(), classPropertyKey.isDynamicNullHandling());
    }

    public static ClassProperty createProperty(Class clazz, String string, boolean bl) {
        return NestedClassProperty.createProperty(clazz, string, string, bl);
    }

    public static ClassProperty createProperty(Class clazz, String string, String string2, boolean bl) {
        String[] stringArray = string2.split(":");
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Property path must have atleast 1 element");
        }
        ArrayList<ClassProperty> arrayList = new ArrayList<ClassProperty>();
        Class<?> clazz2 = clazz;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (i > 0 && NestedClassProperty.lastProperty(arrayList).getAccessMode() == 1) {
                throw new IllegalStateException("Write-Only properties must be last property in chain");
            }
            Class<?> clazz3 = null;
            int n2 = stringArray[i].indexOf("(");
            if (n2 < 0 ^ (n = stringArray[i].indexOf(")")) < 0 || n2 > 0) {
                throw new IllegalArgumentException("Illegal parenthesis");
            }
            if (n2 < 0) {
                if (n >= 0) {
                    throw new IllegalArgumentException("')' without '('");
                }
            } else {
                if (n2 > 0) {
                    throw new IllegalArgumentException("cast must be a prefix");
                }
                if (n < 0) {
                    throw new IllegalArgumentException("'(' without ')'");
                }
                if (stringArray[i].indexOf("(", n2 + 1) >= 0 || stringArray[i].indexOf(")", n + 1) >= 0) {
                    throw new IllegalArgumentException("Illegal cast: '" + stringArray[i] + "'");
                }
                try {
                    clazz3 = Class.forName(stringArray[i].substring(1, n));
                    stringArray[i] = stringArray[i].substring(n + 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("Illegal Cast");
                }
            }
            ClassProperty classProperty = null;
            Class<?> clazz4 = clazz2;
            while (clazz4 != null && classProperty == null) {
                try {
                    classProperty = SimpleClassProperty.createProperty(clazz4, stringArray[i], bl);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    clazz4 = clazz4.getSuperclass();
                }
                catch (IllegalStateException illegalStateException) {
                    clazz4 = clazz4.getSuperclass();
                }
            }
            if (classProperty == null) {
                throw new IllegalArgumentException("Could not resolve '" + string + "' on class '" + clazz2.getName() + "' failed on property '" + stringArray[i]);
            }
            arrayList.add(classProperty);
            clazz2 = clazz3 == null ? classProperty.getPropertyType() : clazz3;
        }
        return new NestedClassProperty(clazz, string, arrayList, bl);
    }

    private static Object instantiate(Class clazz) throws IllegalArgumentException {
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(null);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Failed dynamic null handling: cannot instantiate without a null constructor.");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    protected void compileGet(CodeBuilder codeBuilder) {
        Iterator iterator = this.propertyList.iterator();
        while (iterator.hasNext()) {
            ClassProperty classProperty = (ClassProperty)iterator.next();
            classProperty.compileGet(codeBuilder);
        }
    }

    protected void compileSet(CodeBuilder codeBuilder) {
        LocalVariable localVariable = null;
        codeBuilder.swap();
        if (this.isDynamicNullHandling()) {
            localVariable = codeBuilder.createLocalVariable("lastObject", TypeDesc.OBJECT);
            codeBuilder.loadNull();
            codeBuilder.storeLocal(localVariable);
        }
        Iterator iterator = this.propertyList.iterator();
        ClassProperty classProperty = null;
        while (iterator.hasNext()) {
            ClassProperty classProperty2 = (ClassProperty)iterator.next();
            if (this.isDynamicNullHandling()) {
                codeBuilder.dup();
                Label label = codeBuilder.createLabel();
                codeBuilder.ifNullBranch((Location)label, false);
                codeBuilder.pop();
                TypeDesc typeDesc = TypeDesc.forClass((Class)classProperty2.getDeclaringClass());
                codeBuilder.newObject(typeDesc);
                codeBuilder.dup();
                codeBuilder.invokeConstructor(typeDesc, null);
                if (classProperty != null) {
                    codeBuilder.dup();
                    codeBuilder.loadLocal(localVariable);
                    codeBuilder.swap();
                    classProperty.compileSet(codeBuilder);
                }
                label.setLocation();
                codeBuilder.dup();
                codeBuilder.storeLocal(localVariable);
            }
            if (iterator.hasNext()) {
                classProperty2.compileGet(codeBuilder);
                classProperty = classProperty2;
                continue;
            }
            codeBuilder.swap();
            classProperty2 = NestedClassProperty.lastProperty(this.propertyList);
            classProperty2.compileSet(codeBuilder);
        }
    }

    protected void compileGetTarget(CodeBuilder codeBuilder) {
        Iterator iterator = this.propertyList.iterator();
        while (iterator.hasNext()) {
            ClassProperty classProperty = (ClassProperty)iterator.next();
            if (!iterator.hasNext()) break;
            classProperty.compileGet(codeBuilder);
        }
    }

    public Object getTarget(Object object) {
        Iterator iterator = this.propertyList.iterator();
        while (iterator.hasNext()) {
            ClassProperty classProperty = (ClassProperty)iterator.next();
            if (!iterator.hasNext()) break;
            object = classProperty.getValue(object);
        }
        return object;
    }

    public Object ensureTarget(Object object, Object object2) throws IllegalArgumentException {
        Iterator iterator = this.propertyList.iterator();
        if (object == null) {
            throw new IllegalArgumentException("Null property cannot be the first in the chain!");
        }
        while (iterator.hasNext()) {
            ClassProperty classProperty = (ClassProperty)iterator.next();
            if (!iterator.hasNext()) break;
            Object object3 = classProperty.getValue(object);
            if (object3 == null) {
                if (object2 == null) {
                    return null;
                }
                object3 = NestedClassProperty.instantiate(classProperty.getPropertyType());
                classProperty.setValue(object, object3);
            }
            object = object3;
        }
        return object;
    }

    public Object getValue(Object object) {
        return NestedClassProperty.lastProperty(this.propertyList).getValue(this.getTarget(object));
    }

    public void setValue(Object object, Object object2) throws IllegalArgumentException {
        if (this.isDynamicNullHandling()) {
            if ((object = this.ensureTarget(object, object2)) != null) {
                NestedClassProperty.lastProperty(this.propertyList).setValue(object, object2);
            }
        } else {
            NestedClassProperty.lastProperty(this.propertyList).setValue(this.getTarget(object), object2);
        }
    }
}

