/*
 * Decompiled with CFR 0.152.
 */
package org.trapdoor.properties;

import cojen.classfile.ClassFile;
import cojen.classfile.CodeBuilder;
import cojen.classfile.MethodInfo;
import cojen.classfile.Modifiers;
import cojen.classfile.TypeDesc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.trapdoor.properties.ClassProperty;
import org.trapdoor.properties.ClassPropertyKey;
import org.trapdoor.properties.CompiledProperty;
import org.trapdoor.properties.DynamicClassManager;
import org.trapdoor.properties.NestedClassProperty;

public class PropertyManager {
    private static Logger logger = Logger.getLogger((Class)PropertyManager.class);
    public static final int RUNTIME = 0;
    public static final int COMPILED_RO = 1;
    public static final int COMPILED_RW = 2;
    private static int propertyMode = 2;

    public static void setPropertyMode(int n) {
        propertyMode = n;
    }

    public static int getPropertyMode() {
        return propertyMode;
    }

    public static ClassProperty getProperty(Class clazz, String string, boolean bl) {
        return PropertyManager.getProperty(new ClassPropertyKey(clazz, string, bl));
    }

    public static ClassProperty getProperty(ClassPropertyKey classPropertyKey) {
        try {
            if (propertyMode == 0) {
                return PropertyManager.createProperty(classPropertyKey);
            }
            Object object = DynamicClassManager.getObject(classPropertyKey);
            if (object != null) {
                return (ClassProperty)object;
            }
            switch (propertyMode) {
                case 2: {
                    String string = "org.trapdoor.properties.CompiledProperty$";
                    int n = DynamicClassManager.nextId(string);
                    string = string + n;
                    File file = DynamicClassManager.fileForClass(string);
                    if (file.exists()) {
                        throw new IOException("File exists " + file.getAbsolutePath());
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    try {
                        PropertyManager.writeClassForKey(classPropertyKey, string, fileOutputStream);
                        ((OutputStream)fileOutputStream).close();
                        try {
                            DynamicClassManager.loadClass(string);
                            object = DynamicClassManager.getObject(classPropertyKey);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            object = null;
                        }
                        if (object == null) {
                            throw new IOException("Generated Class could not be re-read");
                        }
                        break;
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Exception exception) {
                        logger.debug((Object)exception);
                        ((OutputStream)fileOutputStream).close();
                        file.delete();
                        return PropertyManager.createProperty(classPropertyKey);
                    }
                }
                case 1: {
                    object = PropertyManager.createProperty(classPropertyKey);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Invalid COMPILATION_MODE");
                }
            }
            return (ClassProperty)object;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    protected static ClassProperty createProperty(ClassPropertyKey classPropertyKey) {
        ClassProperty classProperty = NestedClassProperty.createProperty(classPropertyKey);
        return classProperty;
    }

    protected static void compilePrintln(CodeBuilder codeBuilder, String string) {
        TypeDesc typeDesc = TypeDesc.forClass((Class)System.class);
        TypeDesc typeDesc2 = TypeDesc.forClass(System.out.getClass());
        codeBuilder.loadStaticField(typeDesc, "out", typeDesc2);
        codeBuilder.loadConstant(string);
        codeBuilder.invokeVirtual(typeDesc2, "println", null, new TypeDesc[]{TypeDesc.STRING});
    }

    protected static void compilePrintln(CodeBuilder codeBuilder) {
        TypeDesc typeDesc = TypeDesc.forClass((Class)System.class);
        TypeDesc typeDesc2 = TypeDesc.forClass(System.out.getClass());
        codeBuilder.loadStaticField(typeDesc, "out", typeDesc2);
        codeBuilder.swap();
        codeBuilder.invokeVirtual(typeDesc2, "println", null, new TypeDesc[]{TypeDesc.STRING});
    }

    protected static void loadClass(CodeBuilder codeBuilder, Class clazz) {
        TypeDesc typeDesc = TypeDesc.forClass((Class)Class.class);
        if (clazz.isPrimitive()) {
            codeBuilder.loadStaticField(TypeDesc.forClass((Class)clazz).toObjectType(), "TYPE", typeDesc);
        } else {
            codeBuilder.loadConstant(clazz.getName());
            codeBuilder.invokeStatic(typeDesc, "forName", typeDesc, new TypeDesc[]{TypeDesc.STRING});
        }
    }

    protected static void writeClassForKey(ClassPropertyKey classPropertyKey, String string, OutputStream outputStream) throws IOException {
        ClassProperty classProperty = PropertyManager.createProperty(classPropertyKey);
        ClassFile classFile = new ClassFile(string, CompiledProperty.class);
        TypeDesc typeDesc = TypeDesc.forClass((Class)DynamicClassManager.class);
        TypeDesc typeDesc2 = TypeDesc.forClass((Class)CompiledProperty.class);
        TypeDesc typeDesc3 = TypeDesc.forClass((Class)ClassPropertyKey.class);
        TypeDesc typeDesc4 = TypeDesc.forClass((Class)Class.class);
        TypeDesc typeDesc5 = TypeDesc.forClass((Class)CodeBuilder.class);
        TypeDesc typeDesc6 = TypeDesc.forClass((Class)IllegalStateException.class);
        classFile.addField(Modifiers.PRIVATE.toStatic(true), "key", typeDesc3);
        MethodInfo methodInfo = classFile.addConstructor(Modifiers.PUBLIC, new TypeDesc[]{typeDesc3, TypeDesc.INT, typeDesc4, TypeDesc.BOOLEAN});
        CodeBuilder codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadThis();
        for (int i = 0; i < codeBuilder.getParameterCount(); ++i) {
            codeBuilder.loadLocal(codeBuilder.getParameter(i));
        }
        codeBuilder.invokeSuperConstructor(new TypeDesc[]{typeDesc3, TypeDesc.INT, typeDesc4, TypeDesc.BOOLEAN});
        codeBuilder.returnVoid();
        methodInfo = classFile.addInitializer();
        codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.newObject(typeDesc3);
        codeBuilder.dup();
        codeBuilder.dup();
        PropertyManager.loadClass(codeBuilder, classPropertyKey.getDeclaringClass());
        codeBuilder.loadConstant(classPropertyKey.getPropertyName());
        codeBuilder.loadConstant(classPropertyKey.isDynamicNullHandling());
        codeBuilder.invokeConstructor(TypeDesc.forClass((Class)ClassPropertyKey.class), new TypeDesc[]{typeDesc4, TypeDesc.STRING, TypeDesc.BOOLEAN});
        codeBuilder.storeStaticField("key", typeDesc3);
        codeBuilder.newObject(classFile.getType());
        codeBuilder.dup();
        codeBuilder.loadStaticField("key", typeDesc3);
        codeBuilder.loadConstant(classProperty.getAccessMode());
        PropertyManager.loadClass(codeBuilder, classProperty.getPropertyType());
        codeBuilder.loadConstant(classProperty.isStatic());
        codeBuilder.invokeConstructor(new TypeDesc[]{typeDesc3, TypeDesc.INT, typeDesc4, TypeDesc.BOOLEAN});
        codeBuilder.invokeStatic(typeDesc2, "registerObject", null, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.OBJECT});
        codeBuilder.returnVoid();
        methodInfo = classFile.addMethod(Modifiers.PUBLIC_STATIC, "main", null, new TypeDesc[]{TypeDesc.STRING.toArrayType()});
        codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.invokeStatic("getKey", typeDesc3, null);
        codeBuilder.invokeVirtual(TypeDesc.OBJECT, "toString", TypeDesc.STRING, null);
        PropertyManager.compilePrintln(codeBuilder);
        codeBuilder.returnVoid();
        methodInfo = classFile.addMethod(Modifiers.PUBLIC_STATIC, "getKey", typeDesc3, null);
        codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadStaticField("key", typeDesc3);
        codeBuilder.returnValue(typeDesc3);
        methodInfo = classFile.addMethod(Modifiers.PROTECTED, "compileGet", null, new TypeDesc[]{typeDesc5});
        codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.newObject(typeDesc6);
        codeBuilder.dup();
        codeBuilder.loadConstant("Operation not supported - property already compiled.");
        codeBuilder.invokeConstructor(typeDesc6, new TypeDesc[]{TypeDesc.STRING});
        codeBuilder.throwObject();
        codeBuilder.returnVoid();
        methodInfo = classFile.addMethod(Modifiers.PROTECTED, "compileSet", null, new TypeDesc[]{typeDesc5});
        codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.newObject(typeDesc6);
        codeBuilder.dup();
        codeBuilder.loadConstant("Operation not supported - property already compiled.");
        codeBuilder.invokeConstructor(typeDesc6, new TypeDesc[]{TypeDesc.STRING});
        codeBuilder.throwObject();
        codeBuilder.returnVoid();
        methodInfo = classFile.addMethod(Modifiers.PROTECTED, "compileGetTarget", null, new TypeDesc[]{typeDesc5});
        codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.newObject(typeDesc6);
        codeBuilder.dup();
        codeBuilder.loadConstant("Operation not supported - property already compiled.");
        codeBuilder.invokeConstructor(typeDesc6, new TypeDesc[]{TypeDesc.STRING});
        codeBuilder.throwObject();
        codeBuilder.returnVoid();
        methodInfo = classFile.addMethod(Modifiers.PUBLIC, "getValue", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.OBJECT});
        codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadLocal(codeBuilder.getParameter(0));
        classProperty.compileGet(codeBuilder);
        codeBuilder.returnValue(TypeDesc.OBJECT);
        methodInfo = classFile.addMethod(Modifiers.PUBLIC, "setValue", null, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.OBJECT});
        codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadLocal(codeBuilder.getParameter(0));
        codeBuilder.loadLocal(codeBuilder.getParameter(1));
        classProperty.compileSet(codeBuilder);
        codeBuilder.returnVoid();
        methodInfo = classFile.addMethod(Modifiers.PUBLIC, "getTarget", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.OBJECT});
        codeBuilder = new CodeBuilder(methodInfo);
        codeBuilder.loadLocal(codeBuilder.getParameter(0));
        classProperty.compileGetTarget(codeBuilder);
        codeBuilder.returnValue(TypeDesc.OBJECT);
        classFile.writeTo(outputStream);
    }
}

